#ifndef LLF_ECPKI_DOMAINS_DB_DEF_H
#define LLF_ECPKI_DOMAINS_DB_DEF_H 
/*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  30 March 2008
   *  Last modified   :  % 21 Feb. 2008 %
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version LLF_RSA_domains_db_def.h#1:incl:1
   *  \author R.Levin
   *  \remarks Copyright (C) 2008 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/*
 * This file is #included in the middle of the struct declaration for CRYS_ECPKI_Dmain_t
 * It contains the platform-specific parts of the context struct. As such:
 *
 *  1) file should not use any includes it is a part of the CRYS_ECPKI_Types.h file !!!!
 *  2) only the CRYS_ECPKI_Types.h file should include this file. 
 */ 
  
     struct
     {   
		/*! H1ec = 2^n mod P - variable used for Montgomery reduction*/
		DxUint32_t	H1ec [CRYS_ECPKI_MODUL_MAX_LENGTH_IN_WORDS];
		/*! H2ec = 2^2*n mod P  - variable used for Montgomery conversion*/
		DxUint32_t	H2ec [CRYS_ECPKI_MODUL_MAX_LENGTH_IN_WORDS];
		
		/*! mod0tag - multiplicative inverse of low word of modulus
		             mod0tag = - P[0]^-1 mod 2^sizeof(DxUint32_t)*/
		DxUint32_t   mod0tag;
        
     } LLF;
  

#endif

